<?php
function aiomatic_playground_panel()
{
   $aiomatic_Main_Settings = get_option('aiomatic_Main_Settings', false);
   if (!isset($aiomatic_Main_Settings['app_id']) || trim($aiomatic_Main_Settings['app_id']) == '') 
   {
      ?>
<h1><?php echo esc_html__("You must add an OpenAI API Key into the plugin's 'Main Settings' menu before you can use this feature!", 'aiomatic-automatic-ai-content-writer');?></h1>
<?php
return;
   }
?>
<div class="wp-header-end"></div>
<div class="wrap gs_popuptype_holder seo_pops">
    <div>
        <form id="myFormPlayground" method="post" action="<?php if(is_multisite() && is_network_admin()){echo '../options.php';}else{echo 'options.php';}?>">
        <div class="cr_autocomplete">
 <input type="password" id="PreventChromeAutocomplete" 
  name="PreventChromeAutocomplete" autocomplete="address-level4" />
</div>
<div>

<div class="aiomatic_class">
<table class="widefat">
    <tr>
    <td colspan="2">
        <h1><span class="gs-sub-heading"><b><?php echo esc_html__("AI Playground:", 'aiomatic-automatic-ai-content-writer');?></b>&nbsp;</span>
        <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                        <div class="bws_hidden_help_text cr_min_260px">
<?php
    echo esc_html__("In this playground you will be able to generate text for many purposes.", 'aiomatic-automatic-ai-content-writer');
?>
                        </div>
                    </div></h1>
                    </td>
                    </tr>
                    <tr><td>
                    <div>
        <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                        <div class="bws_hidden_help_text cr_min_260px">
<?php
    echo esc_html__("Set an seed command you want to send to OpenAI. This command can be any given task or order, based on which, it will generate content in the playground. If you enter a seed which is too long, the plugin will automatically trim it to the maximum size accepted by the AI content writer.", 'aiomatic-automatic-ai-content-writer');
?>
                        </div>
                    </div>
                    <b><?php echo esc_html__("Seed Command:", 'aiomatic-automatic-ai-content-writer');?></b>
                    </div>
                    </td><td>
                    <div>
                    <textarea rows="3" name="aiomatic_playground_input" id="aiomatic_playground_input" placeholder="Input your seed expression for the AI writer"></textarea>

        </div>
<?php
echo wp_nonce_field( 'aiomatic_playground_nonce', '_aiomatic_nonce');
?>
        </td></tr>
                    <tr><td>
                    <div>
        <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                        <div class="bws_hidden_help_text cr_min_260px">
<?php
    echo esc_html__("Here you will see the result generated by the AI, for the seed command you sent.", 'aiomatic-automatic-ai-content-writer');
?>
                        </div>
                    </div>
                    <b><?php echo esc_html__("AI Result:", 'aiomatic-automatic-ai-content-writer');?></b>
                    </div>
                    </td><td>
                    <div>
<?php
                    $pro_rte_settings = array(
                        'wpautop' => true,
                        'media_buttons' => false,
                        'textarea_name' => 'aiomatic_playground_output',
                        'textarea_rows' => '15',
                        'tabindex' => '',
                        'editor_css' => '',
                        'editor_class' => 'aiomatic_tinymce',
                        'teeny' => false,
                        'dfw' => false,
                        'tinymce' => true,
                        'quicktags' => true,
                        'drag_drop_upload' => true
                    );
                    wp_editor('', 'aiomatic_rich_form', $pro_rte_settings);
?>
        </div>
        </td></tr>
        
        
        <tr><td colspan="2">
                    <h2><?php echo esc_html__("OpenAI API Settings:", 'aiomatic-automatic-ai-content-writer');?></h2>
                    
                    </td></tr>
                    <tr><td>
        <div>
        <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                        <div class="bws_hidden_help_text cr_min_260px">
<?php
    echo esc_html__("Select the AI Model you want to use.", 'aiomatic-automatic-ai-content-writer');
?>
                        </div>
                    </div>
                    <b><?php echo esc_html__("AI Model To Use:", 'aiomatic-automatic-ai-content-writer');?></b>
                    </div>
                    </td><td>
                    <div>
                    <select id="model" name="aiomatic_playground_model" >
                              <option value="text-davinci-003"><?php echo esc_html__("text-davinci-003", 'aiomatic-automatic-ai-content-writer');?></option>
                              <option value="text-davinci-002"><?php echo esc_html__("text-davinci-002", 'aiomatic-automatic-ai-content-writer');?></option>
                              <option value="text-curie-001"><?php echo esc_html__("text-curie-001", 'aiomatic-automatic-ai-content-writer');?></option>
                                 <option value="text-babbage-001"><?php echo esc_html__("text-babbage-001", 'aiomatic-automatic-ai-content-writer');?></option>
                                    <option value="text-ada-001"><?php echo esc_html__("text-ada-001", 'aiomatic-automatic-ai-content-writer');?></option>
                           </select>
        </div>
                    </td></tr><tr><td>
                    <div>
        <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                        <div class="bws_hidden_help_text cr_min_260px">
<?php
    echo esc_html__("Set the maximum number of API tokens to use with each request. This will define the length of the resulting API response. Each token usually consists of approximately 4 characters. Note that in this value the number of tokens sent to the API as an article seed will also be counted. The maximum amount which can be set it 2048.", 'aiomatic-automatic-ai-content-writer');
?>
                        </div>
                    </div>
                    <b><?php echo esc_html__("Maximum Total Token Count To Use Per API Request:", 'aiomatic-automatic-ai-content-writer');?></b>
                    
                    </td><td>
                    <input type="number" min="1" step="1" max="2048" id="max_tokens" name="aiomatic_playground_max_tokens" class="cr_450" value="" placeholder="Maximum Token Count To Spend on Each Request">
        </div>
        </td></tr><tr><td>
                    <div>
        <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                        <div class="bws_hidden_help_text cr_min_260px">
<?php
    echo esc_html__("Set the maximum number of seed API tokens to use with each request. This will define the length of the resulting API response. Each token usually consists of approximately 4 characters. This defines how much content does the API receive each time you call it. If the API gets more initial data, better quality results will be expected. The maximum amount which can be set it 1000.", 'aiomatic-automatic-ai-content-writer');
?>
                        </div>
                    </div>
                    <b><?php echo esc_html__("Maximum Seed Token Count To Use Per API Request:", 'aiomatic-automatic-ai-content-writer');?></b>
                    
                    </td><td>
                    <input type="number" min="1" step="1" max="1000" id="max_seed_tokens" name="aiomatic_playground_max_seed_tokens" class="cr_450" value="" placeholder="Maximum Seed Token Count To Spend on Each Request">
        </div>
        </td></tr><tr><td>
                    <div>
        <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                        <div class="bws_hidden_help_text cr_min_260px">
<?php
    echo esc_html__("Set the maximum number of result API tokens to use with each request. This will define the length of the resulting API response. Each token usually consists of approximately 4 characters. This defines how much content does the API receive each time you call it. If the API gets more initial data, better quality results will be expected. The maximum amount which can be set it 1000.", 'aiomatic-automatic-ai-content-writer');
?>
                        </div>
                    </div>
                    <b><?php echo esc_html__("Maximum Result Token Count To Use Per API Request:", 'aiomatic-automatic-ai-content-writer');?></b>
                    
                    </td><td>
                    <input type="number" min="1" step="1" max="2048" id="max_result_tokens" name="aiomatic_playground_max_result_tokens" class="cr_450" value="" placeholder="Maximum Result Token Count To Spend on Each Request">
        </div>
        </td></tr><tr><td>
                    <div>
        <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                        <div class="bws_hidden_help_text cr_min_260px">
<?php
    echo esc_html__("What sampling temperature to use. Higher values means the model will take more risks. Try 0.9 for more creative applications, and 0 (argmax sampling) for ones with a well-defined answer. We generally recommend altering this or top_p but not both.", 'aiomatic-automatic-ai-content-writer');
?>
                        </div>
                    </div>
                    <b><?php echo esc_html__("AI Temperature:", 'aiomatic-automatic-ai-content-writer');?></b>
                    
                    </td><td>
                    <input type="number" min="1" step="0.1" id="temperature" name="aiomatic_playground_temperature" class="cr_450" value="" placeholder="1">
        </div>
        </td></tr><tr><td>
                    <div>
        <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                        <div class="bws_hidden_help_text cr_min_260px">
<?php
    echo esc_html__("An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We generally recommend altering this or temperature but not both.", 'aiomatic-automatic-ai-content-writer');
?>
                        </div>
                    </div>
                    <b><?php echo esc_html__("AI Top_p:", 'aiomatic-automatic-ai-content-writer');?></b>
                    
                    </td><td>
                    <input type="number" min="1" step="0.1" max="1" id="top_p" name="aiomatic_playground_top_p" class="cr_450" value="" placeholder="1">
        </div>
        </td></tr><tr><td>
                    <div>
        <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                        <div class="bws_hidden_help_text cr_min_260px">
<?php
    echo esc_html__("Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.", 'aiomatic-automatic-ai-content-writer');
?>
                        </div>
                    </div>
                    <b><?php echo esc_html__("AI Presence Penalty:", 'aiomatic-automatic-ai-content-writer');?></b>
                    
                    </td><td>
                    <input type="number" min="-2" step="0.1" max="2" id="presence_penalty" name="aiomatic_playground_presence_penalty" class="cr_450" value="" placeholder="0">
        </div>
        </td></tr><tr><td>
                    <div>
        <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                        <div class="bws_hidden_help_text cr_min_260px">
<?php
    echo esc_html__("Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.", 'aiomatic-automatic-ai-content-writer');
?>
                        </div>
                    </div>
                    <b><?php echo esc_html__("AI Frequency Penalty:", 'aiomatic-automatic-ai-content-writer');?></b>
                    
                    </td><td>
                    <input type="number" min="-2" step="0.1" max="2" id="frequency_penalty" name="aiomatic_playground_frequency_penalty" class="cr_450" value="" placeholder="0">
        </div>
        </td></tr>
                    </table>
                    </div>
    <div><p class="submit"><input type="button" name="playgroundSubmit" id="playgroundSubmit" class="button button-primary" onclick="aiomatic_playground_submit();" value="<?php echo esc_html__("Submit", 'aiomatic-automatic-ai-content-writer');?>"/></p></div>
    <div id="aiomatic_playground_status">

</div>
    </div>
    </form>
</div>
</div>
<?php
}
?>