<?php
   function aiomatic_items_panel()
   {
   $all_rules = get_option('aiomatic_rules_list', array());
   $rules_count = count($all_rules);
   $rules_per_page = get_option('aiomatic_posts_per_page', 12);
   $max_pages = ceil($rules_count/$rules_per_page);
   if($max_pages == 0)
   {
       $max_pages = 1;
   }
   $aiomatic_Main_Settings = get_option('aiomatic_Main_Settings', false);
   if (!isset($aiomatic_Main_Settings['app_id']) || trim($aiomatic_Main_Settings['app_id']) == '') 
   {
      ?>
<h1><?php echo esc_html__("You must add an OpenAI API Key into the plugin's 'Main Settings' menu before you can use this feature!", 'aiomatic-automatic-ai-content-writer');?></h1>
<?php
return;
   }
   ?>
<div class="wp-header-end"></div>
<div class="wrap gs_popuptype_holder seo_pops">
   <div>
      <form id="myForm" method="post" action="<?php echo (aiomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";?>">
         <?php
            wp_nonce_field('aiomatic_save_rules', '_aiomaticr_nonce');
            
            if (isset($_GET['settings-updated'])) {
            ?>
         <div>
            <p class="cr_saved_notif"><strong><?php echo esc_html__("Settings saved.", 'aiomatic-automatic-ai-content-writer');?></strong></p>
         </div>
         <?php
            }
            ?>
         <div>
            <div class="hideMain">
               <hr/>
               <div class="table-responsive">
                  <table id="mainRules" class="responsive table cr_main_table">
                     <thead>
                        <tr>
                           <th>
                              <?php echo esc_html__("ID", 'aiomatic-automatic-ai-content-writer');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("This is the ID of the rule.", 'aiomatic-automatic-ai-content-writer');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("Post Title List / TXT file URL / RSS Feed URL", 'aiomatic-automatic-ai-content-writer');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Input your desired post titles (one per line), a TXT file with titles (one per line) or a RSS feed URL. The plugin will select a random post title at each run. Nested spintax supported. You can also enter RSS feed URLs, from where the plugin will extract a random post title, each time it runs. If you set a RSS feed URL, an item will be randomly selected from the title/description/content of the RSS feed contents - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins).", 'aiomatic-automatic-ai-content-writer');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("Schedule", 'aiomatic-automatic-ai-content-writer');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Select the interval in hours after which you want this rule to run. Defined in hours.", 'aiomatic-automatic-ai-content-writer');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("# Of Posts", 'aiomatic-automatic-ai-content-writer');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Select the maximum number of posts that this rule can create at once.", 'aiomatic-automatic-ai-content-writer');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("More Options", 'aiomatic-automatic-ai-content-writer');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Shows advanced settings for this rule.", 'aiomatic-automatic-ai-content-writer');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th class="cr_max_width_40">
                              <?php echo esc_html__("Del", 'aiomatic-automatic-ai-content-writer');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Do you want to delete this rule?", 'aiomatic-automatic-ai-content-writer');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th class="cr_max_55">
                              <?php echo esc_html__("Active", 'aiomatic-automatic-ai-content-writer');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Do you want to enable this rule? You can deactivate any rule (you don't have to delete them to deactivate them).", 'aiomatic-automatic-ai-content-writer');
                                       ?>
                                 </div>
                              </div>
                              <br/>
                              <input type="checkbox" onchange="thisonChangeHandler(this)" id="exclusion">
                           </th>
                           <th class="cr_max_42">
                              <?php echo esc_html__("Info", 'aiomatic-automatic-ai-content-writer');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("The number of items (posts, pages) this rule has generated so far.", 'aiomatic-automatic-ai-content-writer');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th class="cr_actions">
                              <?php echo esc_html__("Actions", 'aiomatic-automatic-ai-content-writer');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Do you want to run this rule now? Note that only one instance of a rule is allowed at once.", 'aiomatic-automatic-ai-content-writer');
                                       ?>
                                 </div>
                              </div>
                           </th>
                        </tr>
                        
                     </thead>
                     <tbody>
                        <?php
                           echo aiomatic_expand_rules_manual();
                           if(isset($_GET['aiomatic_page']))
                           {
                              $current_page = $_GET['aiomatic_page'];
                           }
                           else
                           {
                              $current_page = '';
                           }
                           if($current_page == '' || (is_numeric($current_page) && $current_page == $max_pages))
                           {
                           ?>
                        
                        <tr>
                           <td class="cr_short_td">-</td>
                           <td class="cr_loi"><textarea rows="1" name="aiomatic_rules_list[post_title][]" placeholder="Please insert your post titles/TXT file URL/RSS feed URLs" class="cr_width_full"></textarea></td>
                           <td class="cr_comm_td"><input type="number" step="1" min="1" name="aiomatic_rules_list[schedule][]" max="8765812" class="cr_width_60" placeholder="Select the rule schedule interval" value="24"/></td>
                           <td class="cr_comm_td"><input type="number" step="1" min="0" name="aiomatic_rules_list[max][]" class="cr_width_60" placeholder="Select the # of generated posts" value="1" /></td>
                           <td class="cr_width_70">
                              <input type="button" id="mybtnfzr" value="Settings">
                              <div id="mymodalfzr" class="codemodalfzr">
                                 <div class="codemodalfzr-content">
                                    <div class="codemodalfzr-header">
                                       <span id="aiomatic_close" class="codeclosefzr">&times;</span>
                                       <h2><span class="cr_color_white"><?php echo esc_html__("New Rule", 'aiomatic-automatic-ai-content-writer');?></span> <?php echo esc_html__("Advanced Settings", 'aiomatic-automatic-ai-content-writer');?></h2>
                                    </div>
                                    <div class="codemodalfzr-body">
                                       <div class="table-responsive">
                                          <table class="responsive table cr_main_table_nowr">
                                          <tr><td colspan="2">
                                                  <h4><?php echo esc_html__("Rich Content Creation Options", 'aiomatic-automatic-ai-content-writer');?>:</h4>
                                             </td></tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the maximum number of related headings to add to the created post content. This feature will use the 'People Also Ask' feature from Google and Bing. By default, the Bing engine is scraped, if you want to enable also Google scraping, add a SerpAPI key in the plugin's 'Main Settings' menu -> 'SerpAPI API Key' settings field.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Maximum Number Of Related Headings to Add To The Content:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="0" name="aiomatic_rules_list[headings][]" value="" placeholder="Max heading count" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the maximum number of related images to add to the created post content. This feature will use the 'Royalty Free Image' settings from the plugin's 'Main Settings' menu or if you have access to the DallE API.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Maximum Number Of Related Images to Add To The Content:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="0" name="aiomatic_rules_list[images][]" value="" placeholder="Max image count" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Add a related YouTube video to the end of to the created post content. This feature will require you to add at least one YouTube API key in the plugin's 'Main Settings' -> 'YouTube API Key List' settings field.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Add A Related Video To The End Of The Post:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="videos" name="aiomatic_rules_list[videos][]">
                                                </div>
                                                </td>
                                             </tr>
                                          <tr><td colspan="2">
                                                  <h4><?php echo esc_html__("AI Text Generator Options", 'aiomatic-automatic-ai-content-writer');?>:</h4>
                                             </td></tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the AI Model to be used for text generator.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("AI Model For Text Generator:", 'aiomatic-automatic-ai-content-writer');?></b>   
                                                </td>
                                                <td class="cr_min_width_200">
                                                <select id="model" name="aiomatic_rules_list[model][]" class="cr_width_full">
                                                   <option value="text-davinci-003"><?php echo esc_html__("text-davinci-003", 'aiomatic-automatic-ai-content-writer');?></option>
                                                   <option value="text-davinci-002"><?php echo esc_html__("text-davinci-002", 'aiomatic-automatic-ai-content-writer');?></option>
                                                   <option value="text-curie-001"><?php echo esc_html__("text-curie-001", 'aiomatic-automatic-ai-content-writer');?></option>
                                                   <option value="text-babbage-001"><?php echo esc_html__("text-babbage-001", 'aiomatic-automatic-ai-content-writer');?></option>
                                                   <option value="text-ada-001"><?php echo esc_html__("text-ada-001", 'aiomatic-automatic-ai-content-writer');?></option>
                                                </select>   
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set an seed command you want to send to OpenAI. This command can be any given task or order, based on which, it will generate content for posts. You can use the following shortcodes here: %%post_title%%, %%random_sentence%%, %%random_sentence2%%, %%blog_title%%. You can also add a link to a TXT file, containing keywords (one per line), or to an RSS feed. If you use RSS feeds, you can also use the following additional shortcodes: %%post_content%%, %%post_content_plain_text%%, %%post_excerpt%%, %%post_cats%%, %%author_name%%, %%post_link%%. The length of this command should not be greater than the max token count set in the settings for the seed command - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins). You can also add here a link to a .txt file, where you can add multiple prompts (one per line) and the plugin will select a random one at each run.", 'aiomatic-automatic-ai-content-writer');
                                                               echo '&nbsp;' . sprintf( wp_kses( __( "Please check some tips and tricks about writing seed commands, <a href='%s' target='_blank'>here</a>.", 'aiomatic-automatic-ai-content-writer'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://coderevolution.ro/knowledge-base/faq/how-to-create-a-good-seed-prompt-command-for-aiomatic-for-openai-gpt-3-api/' ) );
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Prompt For The OpenAI Text Generator:", 'aiomatic-automatic-ai-content-writer');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/how-to-create-a-good-seed-prompt-command-for-aiomatic-for-openai-gpt-3-api/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <textarea rows="2" cols="70" name="aiomatic_rules_list[ai_command][]" placeholder="Please insert a command for the AI" class="cr_width_full">Write an article in English using HTML with H2,H3,lists and bold,about: "%%post_title%%".</textarea>
                                                </div>
                                                </td>
                                             </tr>
                                          <tr><td colspan="2">
                                                  <h4><?php echo esc_html__("Advanced AI Text Generator Options", 'aiomatic-automatic-ai-content-writer');?>:</h4>
                                             </td></tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the maximum number of API tokens to use with each request. This will define the length of the resulting API response. Each token usually consists of approximately 4 characters. Note that in this value the number of tokens sent to the API as an article seed will also be counted. The maximum amount which can be set it 2048.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Maximum Total Token Count To Use Per API Request:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="1" max="4000" name="aiomatic_rules_list[max_tokens][]" value="" placeholder="2048" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the maximum number of seed API tokens to use with each request. This will define the length of the resulting API response. Each token usually consists of approximately 4 characters. This defines how much content does the API receive each time you call it. If the API gets more initial data, better quality results will be expected. The maximum amount which can be set it 1000.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Maximum Seed Token Count To Use Per API Request:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="1" max="1000" name="aiomatic_rules_list[max_seed_tokens][]" value="" placeholder="1000" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the maximum number of continue API tokens to use with each request. This will define the length of the resulting API response. Each token usually consists of approximately 4 characters. This defines how much content does the API receive each time you call it. If the API gets more initial data, better quality results will be expected. The maximum amount which can be set it 500.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Maximum Continue Token Count To Use Per API Request:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="1" max="1000" name="aiomatic_rules_list[max_continue_tokens][]" value="" placeholder="500" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("What sampling temperature to use. Higher values means the model will take more risks. Try 0.9 for more creative applications, and 0 (argmax sampling) for ones with a well-defined answer. We generally recommend altering this or top_p but not both.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("AI Temperature:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="0" step="0.1" name="aiomatic_rules_list[temperature][]" value="" placeholder="1" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr><tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We generally recommend altering this or temperature but not both.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("AI Top_p:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="0" max="1" step="0.1" name="aiomatic_rules_list[top_p][]" value="" placeholder="1" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr><tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("AI Presence Penalty:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="-2" step="0.1" max="2" name="aiomatic_rules_list[presence_penalty][]" value="" placeholder="0" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr><tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("AI Frequency Penalty:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="0" max="1" step="0.1" name="aiomatic_rules_list[frequency_penalty][]" value="" placeholder="0" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                          <tr><td colspan="2">
                                                  <h4><?php echo esc_html__("AI Image Generator Options", 'aiomatic-automatic-ai-content-writer');?>:</h4>
                                             </td></tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to enable the AI Image Generator and to replace Royalty Free Images with AI generated images?", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Replace Royalty Free Image With AI Generated Images:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="enable_ai_images" name="aiomatic_rules_list[enable_ai_images][]">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set an seed command you want to send to OpenAI image generator. This command can be any given task or order, based on which, it will generate images. You can use the following shortcodes here: %%post_title%%, %%random_sentence%%, %%random_sentence2%%, %%blog_title%%. The length of this command should not be greater than 1000 characters, otherwise the plugin will strip it to 1000 characters length. - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins). You can also add here a link to a .txt file, where you can add multiple prompts (one per line) and the plugin will select a random one at each run.", 'aiomatic-automatic-ai-content-writer');
                                                               echo '&nbsp;' . sprintf( wp_kses( __( "Please check some tips and tricks about writing seed commands, <a href='%s' target='_blank'>here</a>.", 'aiomatic-automatic-ai-content-writer'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://coderevolution.ro/knowledge-base/faq/how-to-create-a-good-seed-prompt-command-for-aiomatic-image-generating-for-openai-dall-e-api/' ) );
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Prompt For The OpenAI Image Generator:", 'aiomatic-automatic-ai-content-writer');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/how-to-create-a-good-seed-prompt-command-for-aiomatic-image-generating-for-openai-dall-e-api/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <textarea rows="2" cols="70" name="aiomatic_rules_list[ai_command_image][]" placeholder="Please insert a command for the AI image generator" class="cr_width_full">A high detail photograph of: "%%post_title%%"</textarea>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the size of the generated image.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Generated Image Size:", 'aiomatic-automatic-ai-content-writer');?></b>   
                                                </td>
                                                <td class="cr_min_width_200">
                                                <select id="model" name="aiomatic_rules_list[image_size][]" class="cr_width_full">
                                                   <option value="256x256"><?php echo esc_html__("256x256", 'aiomatic-automatic-ai-content-writer');?></option>
                                                   <option value="512x512"><?php echo esc_html__("512x512", 'aiomatic-automatic-ai-content-writer');?></option>
                                                   <option value="1024x1024" selected><?php echo esc_html__("1024x1024", 'aiomatic-automatic-ai-content-writer');?></option>
                                                </select>   
                                                </div>
                                                </td>
                                             </tr>
                                          <tr><td colspan="2">
                                                  <h4><?php echo esc_html__("Manual Headings and Images List", 'aiomatic-automatic-ai-content-writer');?>:</h4>
                                             </td></tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Add a list of headings (one on each line) to use in the generated articles. You can use the following shortcodes here: %%post_title%%, %%random_sentence%%, %%random_sentence2%%, %%blog_title%%. - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins).", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Manual List Of Headings:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <textarea rows="2" cols="70" name="aiomatic_rules_list[headings_list][]" placeholder="List of headings" class="cr_width_full"></textarea>
                                                </div>
                                                </td>
                                             </tr><tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Add a list of image URLs (one on each line) to use in the generated articles. - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins).", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Manual List Of Images:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <textarea rows="2" cols="70" name="aiomatic_rules_list[images_list][]" placeholder="List of images" class="cr_width_full"></textarea>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr><td colspan="2">
                                                  <h4><?php echo esc_html__("Posting Options", 'aiomatic-automatic-ai-content-writer');?>:</h4>
                                             </td></tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo sprintf( wp_kses( __( "Select the minimum number of characters that the posts should have. If the API returns content which has fewer characters than this number, another API call will be made, until this character limit is met. Please check about API rate limiting <a href='%s'>here</a>.", 'aiomatic-automatic-ai-content-writer'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://beta.openai.com/docs/api-reference/introduction' ) );
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("AI Content Minimum Character Count:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="1" step="1" name="aiomatic_rules_list[min_char][]" value="500" placeholder="Please insert a minimum number of characters for posts" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Enter a HTML text that should be prepended to the AI generated content in each created post. You can use the following shortcodes: %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%random_video[keyword]%%, %%royalty_free_image_attribution%% - you can also use an optional parameter in the random_image and random_video shortcodes, which will add a percentage chance for the media to appear or not - example: %%random_video[keyword][60]%% - a video will appear in 60% of cases, in the rest of 40%, nothing will be returned by the shortcode - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins).", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("HTML Text To Prepend To AI Created Content:", 'aiomatic-automatic-ai-content-writer');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <textarea rows="2" cols="70" name="aiomatic_rules_list[post_prepend][]" placeholder="HTML content to prepend to the AI generated content" class="cr_width_full"></textarea>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Enter a HTML text that should be appended to the AI generated content in each created post. You can use the following shortcodes: %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%random_video[keyword]%%, %%royalty_free_image_attribution%% - you can also use an optional parameter in the random_image and random_video shortcodes, which will add a percentage chance for the media to appear or not - example: %%random_video[keyword][60]%% - a video will appear in 60% of cases, in the rest of 40%, nothing will be returned by the shortcode - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins).", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("HTML Text To Append To AI Created Content:", 'aiomatic-automatic-ai-content-writer');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <textarea rows="2" cols="70" name="aiomatic_rules_list[post_append][]" placeholder="HTML content to append to the AI generated content" class="cr_width_full"></textarea>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the author that you want to assign for the automatically generated posts.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Post Author:", 'aiomatic-automatic-ai-content-writer');?></b>   
                                                </td>
                                                <td class="cr_min_width_200">
                                                <select id="post_author" name="aiomatic_rules_list[post_author][]" class="cr_width_full">
                                                <?php
                                                   $blogusers = get_users( [ 'role__in' => [ 'contributor', 'author', 'editor', 'administrator' ] ] );
                                                   foreach ($blogusers as $user) {
                                                       echo '<option value="' . esc_html($user->ID) . '"';
                                                       echo '>' . esc_html($user->display_name) . '</option>';
                                                   }
                                                   ?>
                                                </select>   
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the status that you want for the automatically generated posts to have.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Post Status:", 'aiomatic-automatic-ai-content-writer');?></b>   
                                                </td>
                                                <td class="cr_min_width_200">
                                                <select id="submit_status" name="aiomatic_rules_list[submit_status][]" class="cr_width_full">
                                                <option value="pending"><?php echo esc_html__("Pending -> Moderate", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="draft"><?php echo esc_html__("Draft -> Moderate", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="publish" selected><?php echo esc_html__("Published", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="private"><?php echo esc_html__("Private", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="trash"><?php echo esc_html__("Trash", 'aiomatic-automatic-ai-content-writer');?></option>
                                                </select> 
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the type (post/page) for your automatically generated item.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Item Type:", 'aiomatic-automatic-ai-content-writer');?></b>   
                                                </td>
                                                <td class="cr_min_width_200">
                                                <select id="default_type" name="aiomatic_rules_list[default_type][]" class="cr_width_full">
                                                <?php
                                                   $is_first = true;
                                                   foreach ( get_post_types( '', 'names' ) as $post_type ) {
                                                      echo '<option value="' . esc_attr($post_type) . '"';
                                                      if($is_first === true)
                                                      {
                                                          echo ' selected';
                                                          $is_first = false;
                                                      }
                                                      echo '>' . esc_html($post_type) . '</option>';
                                                   }
                                                   ?>
                                                </select>
                                                </div>
                                                </td>
                                             </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Do you want to add a royalty free image to the created post, as a featured image? Please note that for this feature to function you must configure the plugin (add API keys) in the plugin's 'Main Settings' menu -> 'Royalty Free Featured Image Importing Options' section.", 'aiomatic-automatic-ai-content-writer');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Auto Get A Royalty Free Featured Image:", 'aiomatic-automatic-ai-content-writer');?></b>
                                             </td>
                                             <td>
                                             <input type="checkbox" id="royalty_free" name="aiomatic_rules_list[royalty_free][]">
                                             </div>
                                             </td>
                                          </tr>
                                             <tr>
                                                <td>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Insert a comma separated list of links to valid images that will be set randomly for the featured image for the posts that do not have a valid image attached or if you disabled automatical featured image generator. You can also use image numeric IDs from images found in the Media Gallery. To disable this feature, leave this field blank. Spintax supported. You can also use the %%random_image[keyword]%% shortcode to automatically import a random image from Google Image Search with the Creative Commons filter applied. To get a related image, you can also use: %%random_image[%%post_title%%]%%", 'aiomatic-automatic-ai-content-writer');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Default Featured Image List:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                   <input class="cr_width_60p" type="text" name="aiomatic_rules_list[image_url][]" placeholder="Please insert the link to a valid image (spintax supported)" value=""/>
                                                   <input class="cr_width_33p aiomatic_image_button" type="button" value=">>>"/>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("If your template supports 'Post Formats', than you can select one here. If not, leave this at it's default value.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Generated Post Format:", 'aiomatic-automatic-ai-content-writer');?></b>   
                                                </td>
                                                <td class="cr_min_width_200">
                                                <select id="post_format" name="aiomatic_rules_list[post_format][]" class="cr_width_full">
                                                <option value="post-format-standard"  selected><?php echo esc_html__("Standard", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="post-format-aside"><?php echo esc_html__("Aside", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="post-format-gallery"><?php echo esc_html__("Gallery", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="post-format-link"><?php echo esc_html__("Link", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="post-format-image"><?php echo esc_html__("Image", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="post-format-quote"><?php echo esc_html__("Quote", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="post-format-status"><?php echo esc_html__("Status", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="post-format-video"><?php echo esc_html__("Video", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="post-format-audio"><?php echo esc_html__("Audio", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="post-format-chat"><?php echo esc_html__("Chat", 'aiomatic-automatic-ai-content-writer');?></option>
                                                </select>     
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the post category that you want for the automatically generated posts to have.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Additional Post Category:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <select id="default_category" name="aiomatic_rules_list[default_category][]" class="cr_width_full">
                                                <option value="aiomatic_no_category_12345678" selected><?php echo esc_html__("Do Not Add a Category", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <?php
                                                   $cat_args   = array(
                                                       'orderby' => 'name',
                                                       'hide_empty' => 0,
                                                       'order' => 'ASC'
                                                   );
                                                   $categories = get_categories($cat_args);
                                                   foreach ($categories as $category) {
                                                   ?>
                                                <option value="<?php
                                                   echo esc_html($category->term_id);
                                                   ?>"><?php
                                                   echo esc_html(sanitize_text_field($category->name));
                                                   ?></option>
                                                <?php
                                                   }
                                                   ?>
                                                </select>     
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to automatically add post categories from the generated items?", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Auto Add Categories:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <select class="cr_width_full" id="auto_categories" name="aiomatic_rules_list[auto_categories][]">
                                                <option value="disabled" selected><?php echo esc_html__("Disabled", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="hashtags"><?php echo esc_html__("Title", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="content"><?php echo esc_html__("Content", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="both"><?php echo esc_html__("Title and Content", 'aiomatic-automatic-ai-content-writer');?></option>
                                                </select>   
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("This feature will try to remove the WordPress's default post category. This may fail in case no additional categories are added, because WordPress requires at least one post category for every post.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Remove WP Default Post Category:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="remove_default" name="aiomatic_rules_list[remove_default][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to automatically add post tags from the generated items?", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Auto Add Tags:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <select class="cr_width_full" id="auto_tags" name="aiomatic_rules_list[auto_tags][]">
                                                <option value="disabled" selected><?php echo esc_html__("Disabled", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="hashtags"><?php echo esc_html__("Title", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="content"><?php echo esc_html__("Content", 'aiomatic-automatic-ai-content-writer');?></option>
                                                <option value="both"><?php echo esc_html__("Title and Content", 'aiomatic-automatic-ai-content-writer');?></option>
                                                </select> 
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the post tags that you want for the automatically generated posts to have. Spintax supported.", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Additional Post Tags:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="text" name="aiomatic_rules_list[default_tags][]" value="" placeholder="Please insert your additional post tags here" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to enable comments for the generated posts?", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Enable Comments For Posts:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="enable_comments" name="aiomatic_rules_list[enable_comments][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to enable pingbacks/trackbacks for the generated posts?", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Enable Pingback/Trackback:", 'aiomatic-automatic-ai-content-writer');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="enable_pingback" name="aiomatic_rules_list[enable_pingback][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the custom fields that will be set for generated posts. The syntax for this field is the following: custom_field_name1 => custom_field_value1, custom_field_name2 => custom_field_value2, ... .", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Post Custom Fields:", 'aiomatic-automatic-ai-content-writer');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <textarea rows="1" cols="70" name="aiomatic_rules_list[custom_fields][]" placeholder="Please insert your desired custom fields. Example: title_custom_field => %%post_title%%" class="cr_width_full"></textarea>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the custom taxonomies that will be set for generated posts. The syntax for this field is the following: custom_taxonomy_name1 => custom_taxonomy_value1A, custom_taxonomy_value1B; custom_taxonomy_name2 => custom_taxonomy_value2A, custom_taxonomy_value2B; ... .", 'aiomatic-automatic-ai-content-writer');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Post Custom Taxonomies:", 'aiomatic-automatic-ai-content-writer');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <textarea rows="1" cols="70" name="aiomatic_rules_list[custom_tax][]" placeholder="Please insert your desired custom taxonomies. Example: custom_taxonomy_name => %%post_title%%" class="cr_width_full"></textarea>
                                                </div>
                                                </td>
                                             </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Enter a 2 letter language code that will be assigned as the WPML/Polylang language for posts. Example: for German, input: de", 'aiomatic-automatic-ai-content-writer');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Assign WPML/Polylang Language to Posts:", 'aiomatic-automatic-ai-content-writer');?></b>
                                             </td>
                                             <td>
                                             <input type="text" class="cr_width_full" name="aiomatic_rules_list[wpml_lang][]" value="" placeholder="WPML/Polylang language" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                          </table>
                                       </div>
                                    </div>
                                    <div class="codemodalfzr-footer">
                                       <br/>
                                       <h3 class="cr_inline">Aiomatic Automatic Post Generator</h3>
                                       <span id="aiomatic_ok" class="codeokfzr cr_inline">OK&nbsp;</span>
                                       <br/><br/>
                                    </div>
                                 </div>
                              </div>
                           </td>
                           <td class="cr_shrt_td2"><span class="cr_gray20">X</span></td>
                           <td class="cr_short_td"><input type="checkbox" name="aiomatic_rules_list[active][]" value="1" checked />
                              <input type="hidden" name="aiomatic_rules_list[last_run][]" value="1988-01-27 00:00:00"/>
                           </td>
                           <td class="cr_short_td">
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("No info.", 'aiomatic-automatic-ai-content-writer');
                                       ?>
                                 </div>
                              </div>
                           </td>
                           <td class="cr_center">
                              <div>
                                 <img src="<?php
                                    echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/running.gif');
                                    ?>" alt="Running" class="cr_running">
                                 <div class="codemainfzr cr_gray_back">
                                    <select id="actions" class="actions" name="actions" disabled>
                                       <option value="select" disabled selected><?php echo esc_html__("Select an Action", 'aiomatic-automatic-ai-content-writer');?></option>
                                       <option value="run" onclick=""><?php echo esc_html__("Run This Rule Now", 'aiomatic-automatic-ai-content-writer');?></option>
                                       <option value="trash" onclick=""><?php echo esc_html__("Move All Posts To Trash", 'aiomatic-automatic-ai-content-writer');?></option>
                                       <option value="duplicate" onclick=""><?php echo esc_html__("Duplicate This Rule", 'aiomatic-automatic-ai-content-writer');?></option>
                                       <option value="delete" onclick=""><?php echo esc_html__("Permanently Delete All Posts", 'aiomatic-automatic-ai-content-writer');?></option>
                                    </select>
                                 </div>
                              </div>
                           </td>
                        </tr>
                     <?php
                        }
                        ?>
                     </tbody>
                  </table>
               </div>
            </div>
         </div>
         <hr/>
         
      <div>
         <?php
            $next_url = (aiomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($next_url, 'aiomatic_page=') === false)
            {
                if(stristr($next_url, '?') === false)
                {
                    if($max_pages == 1)
                    {
                        $next_url .= '?aiomatic_page=1';
                    }
                    else
                    {
                        $next_url .= '?aiomatic_page=2';
                    }
                }
                else
                {
                    if($max_pages == 1)
                    {
                        $next_url .= '&aiomatic_page=1';
                    }
                    else
                    {
                        $next_url .= '&aiomatic_page=2';
                    }
                }
            }
            else
            {
                if(isset($_GET['aiomatic_page']))
                {
                    $curent_page = $_GET["aiomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $next_page = $curent_page + 1;
                    if($next_page > $max_pages)
                    {
                        $next_page = $max_pages;
                    }
                    if($next_page <= 0)
                    {
                        $next_page = 1;
                    }
                    $next_url = str_replace('aiomatic_page=' . $curent_page, 'aiomatic_page=' . $next_page, $next_url);
                }
                else
                {
                    if(stristr($next_url, '?') === false)
                    {
                        if($max_pages == 1)
                        {
                            $next_url .= '?aiomatic_page=1';
                        }
                        else
                        {
                            $next_url .= '?aiomatic_page=2';
                        }
                    }
                    else
                    {
                        if($max_pages == 1)
                        {
                            $next_url .= '&aiomatic_page=1';
                        }
                        else
                        {
                            $next_url .= '&aiomatic_page=2';
                        }
                    }
                }
            }
            $prev_url = (aiomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($prev_url, 'aiomatic_page=') === false)
            {
                if(stristr($prev_url, '?') === false)
                {
                    $prev_url .= '?aiomatic_page=1';
                }
                else
                {
                    $prev_url .= '&aiomatic_page=1';
                }
            }
            else
            {
                if(isset($_GET['aiomatic_page']))
                {
                    $curent_page = $_GET["aiomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $go_to = $curent_page - 1;
                    if($go_to <= 0)
                    {
                        $go_to = 1;
                    }
                    if($go_to > $max_pages)
                    {
                        $go_to = $max_pages;
                    }
                    $prev_url = str_replace('aiomatic_page=' . $curent_page, 'aiomatic_page=' . $go_to, $prev_url);
                }
                else
                {
                    if(stristr($prev_url, '?') === false)
                    {
                        $prev_url .= '?aiomatic_page=1';
                    }
                    else
                    {
                        $prev_url .= '&aiomatic_page=1';
                    }
                }
            }
            $first_url = (aiomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($first_url, 'aiomatic_page=') === false)
            {
                if(stristr($first_url, '?') === false)
                {
                    $first_url .= '?aiomatic_page=1';
                }
                else
                {
                    $first_url .= '&aiomatic_page=1';
                }
            }
            else
            {
                if(isset($_GET['aiomatic_page']))
                {
                    $curent_page = $_GET["aiomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $first_url = str_replace('aiomatic_page=' . $curent_page, 'aiomatic_page=1', $first_url);
                }
                else
                {
                    if(stristr($first_url, '?') === false)
                    {
                        $first_url .= '?aiomatic_page=1';
                    }
                    else
                    {
                        $first_url .= '&aiomatic_page=1';
                    }
                }
            }
            $last_url = (aiomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($last_url, 'aiomatic_page=') === false)
            {
                if(stristr($last_url, '?') === false)
                {
                    $last_url .= '?aiomatic_page=' . $max_pages;
                }
                else
                {
                    $last_url .= '&aiomatic_page=' . $max_pages;
                }
            }
            else
            {
                if(isset($_GET['aiomatic_page']))
                {
                    $curent_page = $_GET["aiomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $last_url = str_replace('aiomatic_page=' . $curent_page, 'aiomatic_page=' . $max_pages, $last_url);
                }
                else
                {
                    if(stristr($last_url, '?') === false)
                    {
                        $last_url .= '?aiomatic_page=' . $max_pages;
                    }
                    else
                    {
                        $last_url .= '&aiomatic_page=' . $max_pages;
                    }
                }
            }
            if(isset($_GET['aiomatic_page']))
            {
                $this_page = $_GET["aiomatic_page"];
            }
            else
            {
                $this_page = '1';
            }
            echo '<center><a href="' . esc_url($first_url) . '">' . esc_html__('First Page', 'aiomatic-automatic-ai-content-writer') . '</a>&nbsp;&nbsp;&nbsp;<a href="' . esc_url($prev_url) . '">' . esc_html__('Previous Page', 'aiomatic-automatic-ai-content-writer') . '</a>&nbsp;&nbsp;' . esc_html__('Page', 'aiomatic-automatic-ai-content-writer') . ' ' . esc_html($this_page) . ' ' . esc_html__('of', 'aiomatic-automatic-ai-content-writer') . ' ' . esc_html($max_pages) . '&nbsp;-&nbsp;' . esc_html__("Rules Per Page:", 'aiomatic-automatic-ai-content-writer') . '&nbsp;&nbsp;<input class="cr_50" type="number" min="2" step="1" max="999" name="posts_per_page" value="' . esc_attr($rules_per_page). '" required/>&nbsp;&nbsp;&nbsp;<a href="' . esc_url($next_url) . '">' . esc_html__('Next Page', 'aiomatic-automatic-ai-content-writer') . '</a>&nbsp;&nbsp;&nbsp;<a href="' . esc_url($last_url) . '">' . esc_html__('Last Page', 'aiomatic-automatic-ai-content-writer') . '</a></center>
            <center></center>
            <center>Info: You can add new rules only on the last page.</center>';
            ?> 
         <div>
            <p class="submit"><input type="submit" name="btnSubmit" id="btnSubmit" class="button button-primary" onclick="unsaved = false;" value="<?php echo esc_html__("Save Settings", 'aiomatic-automatic-ai-content-writer');?>"/></p>
         </div>
         <div>
            <a href="https://www.youtube.com/watch?v=5rbnu_uis7Y" target="_blank"><?php echo esc_html__("Nested Shortcodes also supported!", 'aiomatic-automatic-ai-content-writer');?></a><br/><?php echo esc_html__("Confused about rule running status icons?", 'aiomatic-automatic-ai-content-writer');?> <a href="http://coderevolution.ro/knowledge-base/faq/how-to-interpret-the-rule-running-visual-indicators-red-x-yellow-diamond-green-tick-from-inside-plugins/" target="_blank"><?php echo esc_html__("More info", 'aiomatic-automatic-ai-content-writer');?></a><br/>
            <div class="cr_none" id="midas_icons">
               <table>
                  <tr>
                     <td><img id="run_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/running.gif');?>" alt="Running" title="status"></td>
                     <td><?php echo esc_html__("In Progress", 'aiomatic-automatic-ai-content-writer');?> - <b><?php echo esc_html__("Importing is Running", 'aiomatic-automatic-ai-content-writer');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="ok_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/ok.gif');?>" alt="OK"  title="status"></td>
                     <td><?php echo esc_html__("Success", 'aiomatic-automatic-ai-content-writer');?> - <b><?php echo esc_html__("New Posts Created", 'aiomatic-automatic-ai-content-writer');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="fail_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/failed.gif');?>" alt="Faield" title="status"></td>
                     <td><?php echo esc_html__("Failed", 'aiomatic-automatic-ai-content-writer');?> - <b><?php echo esc_html__("An Error Occurred.", 'aiomatic-automatic-ai-content-writer');?> <b><?php echo esc_html__("Please check 'Activity and Logging' plugin menu for details.", 'aiomatic-automatic-ai-content-writer');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="nochange_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/nochange.gif');?>" alt="NoChange" title="status"></td>
                     <td><?php echo esc_html__("No Change - No New Posts Created", 'aiomatic-automatic-ai-content-writer');?> - <b><?php echo esc_html__("Possible reasons:", 'aiomatic-automatic-ai-content-writer');?></b></td>
                  </tr>
                  <tr>
                     <td></td>
                     <td>
                        <ul>
                           <li>&#9658; <?php echo esc_html__("Already all posts are published that match your search and posts will be posted when new content will be available", 'aiomatic-automatic-ai-content-writer');?></li>
                           <li>&#9658; <?php echo esc_html__("Some restrictions you defined in the plugin's 'Main Settings'", 'aiomatic-automatic-ai-content-writer');?> <i>(<?php echo esc_html__("example: 'Minimum Content Word Count', 'Maximum Content Word Count', 'Minimum Title Word Count', 'Maximum Title Word Count', 'Banned Words List', 'Reuired Words List', 'Skip Posts Without Images'", 'aiomatic-automatic-ai-content-writer');?>)</i> <?php echo esc_html__("prevent posting of new posts.", 'aiomatic-automatic-ai-content-writer');?></li>
                        </ul>
                     </td>
                  </tr>
               </table>
            </div>
         </div>
      </form>
   </div>
</div>
<?php
   }
   if (isset($_POST['aiomatic_rules_list'])) {
       add_action('admin_init', 'aiomatic_save_rules_manual');
   }
   
   function aiomatic_save_rules_manual($data2)
   {
       $init_rules_per_page = get_option('aiomatic_posts_per_page', 12);
       $rules_per_page = get_option('aiomatic_posts_per_page', 12);
       if(isset($_POST['posts_per_page']))
       {
           update_option('aiomatic_posts_per_page', $_POST['posts_per_page']);
       }
       check_admin_referer('aiomatic_save_rules', '_aiomaticr_nonce');
       
       $data2 = $_POST['aiomatic_rules_list'];
       $rules = get_option('aiomatic_rules_list', array());
       $initial_count = count($rules);
       $add = false;
       $scad = false;
       if(isset($_GET["aiomatic_page"]) && is_numeric($_GET["aiomatic_page"]))
       {
           $curent_page = $_GET["aiomatic_page"];
       }
       else
       {
           $curent_page = 1;
       }
       $offset = ($curent_page - 1) * $rules_per_page;
       $cont  = 0;
       if (isset($data2['post_title'][0])) {
           for ($i = 0; $i < sizeof($data2['post_title']); ++$i) 
           {
               $bundle = array();
               if (isset($data2['schedule'][$i]) && $data2['schedule'][$i] != '' && $data2['post_title'][$i] != '') {
                   $bundle[] = trim(sanitize_text_field($data2['schedule'][$i]));
                   if (isset($data2['active'][$i])) {
                       $bundle[] = trim(sanitize_text_field($data2['active'][$i]));
                   } else {
                       $bundle[] = '0';
                   }
                   $bundle[]     = trim(sanitize_text_field($data2['last_run'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['max'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['submit_status'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['default_type'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['post_author'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['default_tags'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['default_category'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['auto_categories'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['auto_tags'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['enable_comments'][$i]));
                   $bundle[]     = trim($data2['image_url'][$i]);
                   $bundle[]     = $data2['post_title'][$i];
                   $bundle[]     = trim(sanitize_text_field($data2['enable_pingback'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['post_format'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['min_char'][$i]));
                   $bundle[]     = trim($data2['custom_fields'][$i]);
                   $bundle[]     = trim($data2['custom_tax'][$i]);
                   $bundle[]     = trim($data2['temperature'][$i]);
                   $bundle[]     = trim($data2['top_p'][$i]);
                   $bundle[]     = trim($data2['presence_penalty'][$i]);
                   $bundle[]     = trim($data2['frequency_penalty'][$i]);
                   $bundle[]     = trim($data2['royalty_free'][$i]);
                   $bundle[]     = trim($data2['ai_command'][$i]);
                   $bundle[]     = trim($data2['max_tokens'][$i]);
                   $bundle[]     = trim($data2['max_seed_tokens'][$i]);
                   $bundle[]     = trim($data2['max_continue_tokens'][$i]);
                   $bundle[]     = trim($data2['model'][$i]);
                   $bundle[]     = trim($data2['headings'][$i]);
                   $bundle[]     = trim($data2['images'][$i]);
                   $bundle[]     = trim($data2['videos'][$i]);
                   $bundle[]     = trim($data2['post_prepend'][$i]);
                   $bundle[]     = trim($data2['post_append'][$i]);
                   $bundle[]     = trim($data2['enable_ai_images'][$i]);
                   $bundle[]     = trim($data2['ai_command_image'][$i]);
                   $bundle[]     = trim($data2['image_size'][$i]);
                   $bundle[]     = trim($data2['headings_list'][$i]);
                   $bundle[]     = trim($data2['images_list'][$i]);
                   $bundle[]     = trim($data2['wpml_lang'][$i]);
                   $bundle[]     = trim($data2['remove_default'][$i]);
                   $rules[$offset + $cont] = $bundle;
                   $cont++;
               }
           }
           while($cont < $init_rules_per_page)
           {
               if(isset($rules[$offset + $cont]))
               {
                   $rules[$offset + $cont] = false;
               }
               $cont = $cont + 1;
           }
           $rules = array_values(array_filter($rules));
       }
       $final_count = count($rules);
       if($final_count > $initial_count)
       {
           $add = true;
       }
       elseif($final_count < $initial_count)
       {
           $scad = true;
       }
       update_option('aiomatic_rules_list', $rules, false);
       if(count($rules) % $rules_per_page === 1 && $add === true)
       {
           $rules_count = count($rules);
           $max_pages = ceil($rules_count/$rules_per_page);
           if($max_pages == 0)
           {
               $max_pages = 1;
           }
           $last_url = (aiomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
           if(stristr($last_url, 'aiomatic_page=') === false)
           {
               if(stristr($last_url, '?') === false)
               {
                   $last_url .= '?aiomatic_page=' . $max_pages;
               }
               else
               {
                   $last_url .= '&aiomatic_page=' . $max_pages;
               }
           }
           else
           {
               if(isset($_GET['aiomatic_page']))
               {
                   $curent_page = $_GET["aiomatic_page"];
               }
               else
               {
                   $curent_page = '';
               }
               if(is_numeric($curent_page))
               {
                   $last_url = str_replace('aiomatic_page=' . $curent_page, 'aiomatic_page=' . $max_pages, $last_url);
               }
               else
               {
                   if(stristr($last_url, '?') === false)
                   {
                       $last_url .= '?aiomatic_page=' . $max_pages;
                   }
                   else
                   {
                       $last_url .= '&aiomatic_page=' . $max_pages;
                   }
               }
           }
           aiomatic_redirect($last_url);
       }
       elseif(count($rules) != 0 && count($rules) % $rules_per_page === 0 && $scad === true)
       {
           $rules_count = count($rules);
           $max_pages = ceil($rules_count/$rules_per_page);
           if($max_pages == 0)
           {
               $max_pages = 1;
           }
           $last_url = (aiomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
           if(stristr($last_url, 'aiomatic_page=') === false)
           {
               if(stristr($last_url, '?') === false)
               {
                   $last_url .= '?aiomatic_page=' . $max_pages;
               }
               else
               {
                   $last_url .= '&aiomatic_page=' . $max_pages;
               }
           }
           else
           {
               if(isset($_GET['aiomatic_page']))
               {
                   $curent_page = $_GET["aiomatic_page"];
               }
               else
               {
                   $curent_page = '';
               }
               if(is_numeric($curent_page))
               {
                   $last_url = str_replace('aiomatic_page=' . $curent_page, 'aiomatic_page=' . $max_pages, $last_url);
               }
               else
               {
                   if(stristr($last_url, '?') === false)
                   {
                       $last_url .= '?aiomatic_page=' . $max_pages;
                   }
                   else
                   {
                       $last_url .= '&aiomatic_page=' . $max_pages;
                   }
               }
           }
           aiomatic_redirect($last_url);
       }
   }
   function aiomatic_redirect($url, $statusCode = 301)
   {
     if(!function_exists('wp_redirect'))
     {
        include_once( ABSPATH . 'wp-includes/pluggable.php' );
     }
     wp_redirect($url, $statusCode);
     die();
   }
   function aiomatic_expand_rules_manual()
   {
       if (!get_option('aiomatic_running_list')) {
           $running = array();
       } else {
           $running = get_option('aiomatic_running_list');
       }
       $GLOBALS['wp_object_cache']->delete('aiomatic_rules_list', 'options');
       $rules  = get_option('aiomatic_rules_list');
    if(!is_array($rules))
    {
       $rules = array();
    }
       $output = '';
       $cont   = 0;
       if (!empty($rules)) {
           $posted_items = array();
           $post_list = array();
           $postsPerPage = 50000;
           $paged = 0;
           do
           {
               $postOffset = $paged * $postsPerPage;
               $query = array(
                   'post_status' => array(
                       'publish',
                       'draft',
                       'pending',
                       'trash',
                       'private',
                       'future'
                   ),
                   'post_type' => array(
                       'any'
                   ),
                   'numberposts' => $postsPerPage,
                   'meta_key' => 'aiomatic_parent_rule',
                   'fields' => 'ids',
                   'offset'  => $postOffset
               );
               $got_me = get_posts($query);
               $post_list = array_merge($post_list, $got_me);
               $paged++;
           }while(!empty($got_me));
           wp_suspend_cache_addition(true);
           foreach ($post_list as $post) {
               $rule_id = get_post_meta($post, 'aiomatic_parent_rule', true);
               if ($rule_id != '') {
                   $posted_items[] = $rule_id;
               }
           }
           wp_suspend_cache_addition(false);
           $counted_vals = array_count_values($posted_items);
           if(isset($_GET["aiomatic_page"]) && is_numeric($_GET["aiomatic_page"]))
           {
               $curent_page = $_GET["aiomatic_page"];
           }
           else
           {
               $curent_page = 1;
           }
           $rules_per_page = get_option('aiomatic_posts_per_page', 12);
           foreach ($rules as $request => $bundle[]) {
               if(($cont < ($curent_page - 1) * $rules_per_page) || ($cont >= $curent_page * $rules_per_page))
               {
                  $cont++;
                  continue;
               }
               if (isset($counted_vals[$cont])) {
                   $generated_posts = $counted_vals[$cont];
               } else {
                   $generated_posts = 0;
               }
               $bundle_values          = array_values($bundle);
               $myValues               = $bundle_values[$cont];
               $array_my_values        = array_values($myValues);for($iji=0;$iji<count($array_my_values);++$iji){if(is_string($array_my_values[$iji])){$array_my_values[$iji]=stripslashes($array_my_values[$iji]);}}
               $schedule               = $array_my_values[0];
               $active                 = $array_my_values[1];
               $last_run               = $array_my_values[2];
               $max                    = $array_my_values[3];
               $status                 = $array_my_values[4];
               $def_type               = $array_my_values[5];
               $post_user_name         = $array_my_values[6];
               $default_tags           = $array_my_values[7];
               $default_category       = $array_my_values[8];
               $auto_categories        = $array_my_values[9];
               $auto_tags              = $array_my_values[10];
               $enable_comments        = $array_my_values[11];
               $image_url              = $array_my_values[12];
               $post_title             = $array_my_values[13];
               $enable_pingback        = $array_my_values[14];
               $post_format            = $array_my_values[15];
               $min_char               = $array_my_values[16];
               $custom_fields          = $array_my_values[17];
               $custom_tax             = $array_my_values[18];
               $temperature            = $array_my_values[19];
               $top_p                  = $array_my_values[20];
               $presence_penalty       = $array_my_values[21];
               $frequency_penalty      = $array_my_values[22];
               $royalty_free           = $array_my_values[23];
               $ai_command             = $array_my_values[24];
               $max_tokens             = $array_my_values[25];
               $max_seed_tokens        = $array_my_values[26];
               $max_continue_tokens    = $array_my_values[27];
               $model                  = $array_my_values[28];
               $headings               = $array_my_values[29];
               $images                 = $array_my_values[30];
               $videos                 = $array_my_values[31];
               $post_prepend           = $array_my_values[32];
               $post_append            = $array_my_values[33];
               $enable_ai_images       = $array_my_values[34];
               $ai_command_image       = $array_my_values[35];
               $image_size             = $array_my_values[36];
               $headings_list          = $array_my_values[37];
               $images_list            = $array_my_values[38];
               $wpml_lang              = $array_my_values[39];
               $remove_default         = $array_my_values[40];
               wp_add_inline_script('aiomatic-footer-script', 'createAdmin(' . esc_html($cont) . ');', 'after');
               $output .= '<tr>
                           <td class="cr_short_td">' . esc_html($cont) . '</td>
                           <td class="cr_loi"><textarea rows="1" name="aiomatic_rules_list[post_title][]" placeholder="Please insert your post titles/RSS feed URLs" class="cr_width_full">' . htmlspecialchars($post_title) . '</textarea></td>
                           <td class="cr_comm_td"><input type="number" step="1" min="1" placeholder="# h" name="aiomatic_rules_list[schedule][]" max="8765812" value="' . esc_attr($schedule) . '" class="cr_width_60" required></td>
                           <td class="cr_comm_td"><input type="number" step="1" min="0" placeholder="#" name="aiomatic_rules_list[max][]" value="' . esc_attr($max) . '"  class="cr_width_60" required></td>
                       <td class="cr_width_70">
                       <input type="button" id="mybtnfzr' . esc_html($cont) . '" value="Settings">
                       <div id="mymodalfzr' . esc_html($cont) . '" class="codemodalfzr">
     <div class="codemodalfzr-content">
       <div class="codemodalfzr-header">
         <span id="aiomatic_close' . esc_html($cont) . '" class="codeclosefzr">&times;</span>
         <h2>' . esc_html__('Rule', 'aiomatic-automatic-ai-content-writer') . ' <span class="cr_color_white">ID ' . esc_html($cont) . '</span> ' . esc_html__('Advanced Settings', 'aiomatic-automatic-ai-content-writer') . '</h2>
       </div>
       <div class="codemodalfzr-body">
       <div class="table-responsive">
         <table class="responsive table cr_main_table_nowr">
         <tr><td colspan="2"><h4>' . esc_html__('Rich Content Creation Options', 'aiomatic-automatic-ai-content-writer') . ':</h4></td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the maximum number of related headings to add to the created post content. This feature will use the 'People Also Ask' feature from Google and Bing. By default, the Bing engine is scraped, if you want to enable also Google scraping, add a SerpAPI key in the plugin's 'Main Settings' menu -> 'SerpAPI API Key' settings field.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("Maximum Number Of Related Headings to Add To The Content", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     </td><td>
                     <input type="number" min="0" name="aiomatic_rules_list[headings][]" value="' . esc_attr($headings) . '" placeholder="Maximum headings count" class="cr_width_full">
                         
         </div>
         </td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the maximum number of related images to add to the created post content. This feature will use the royalty free image sources configured in the plugin's 'Main Settings' menu or if you have access to the DallE API.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("Maximum Number Of Related Images to Add To The Content", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     </td><td>
                     <input type="number" min="0" name="aiomatic_rules_list[images][]" value="' . esc_attr($images) . '" placeholder="Maximum image count" class="cr_width_full">
                         
         </div>
         </td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Add a related YouTube video to the end of to the created post content. This feature will require you to add at least one YouTube API key in the plugin's 'Main Settings' -> 'YouTube API Key List' settings field.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("Add A Related Video To The End Of The Post", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     </td><td>
                     <input type="checkbox" id="videos" name="aiomatic_rules_list[videos][]"';
               if ($videos == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                         
         </div>
         </td></tr>
         <tr><td colspan="2"><h4>' . esc_html__('AI Text Generator Options', 'aiomatic-automatic-ai-content-writer') . ':</h4></td></tr><tr><td>
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the AI Model to be used for the text generator.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("AI Model For The Text Generator", 'aiomatic-automatic-ai-content-writer') . ':</b>   
                     </td><td class="cr_min_width_200">
                     <select id="model" name="aiomatic_rules_list[model][]" class="cr_width_full">
                                    <option value="text-davinci-003"';
             if ($model == 'text-davinci-003') {
                 $output .= ' selected';
             }
             $output .= '>' . esc_html__("text-davinci-003", 'aiomatic-automatic-ai-content-writer') . '</option>
                                   <option value="text-davinci-002"';
             if ($model == 'text-davinci-002') {
                 $output .= ' selected';
             }
             $output .= '>' . esc_html__("text-davinci-002", 'aiomatic-automatic-ai-content-writer') . '</option>
                                   <option value="text-curie-001"';
             if ($model == 'text-curie-001') {
                 $output .= ' selected';
             }
             $output .= '>' . esc_html__("text-curie-001", 'aiomatic-automatic-ai-content-writer') . '</option>
                                   <option value="text-babbage-001"';
             if ($model == 'text-babbage-001') {
                 $output .= ' selected';
             }
             $output .= '>' . esc_html__("text-babbage-001", 'aiomatic-automatic-ai-content-writer') . '</option>
                                   <option value="text-ada-001"';
             if ($model == 'text-ada-001') {
                 $output .= ' selected';
             }
             $output .= '>' . esc_html__("text-ada-001", 'aiomatic-automatic-ai-content-writer') . '</option>
                     </select>
         </div>
         </td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set an seed command you want to send to OpenAI. This command can be any given task or order, based on which, it will generate content for posts. You can use the following shortcodes here: %%post_title%%, %%random_sentence%%, %%random_sentence2%%, %%blog_title%%. You can also add a link to a TXT file, containing keywords (one per line), or to an RSS feed. If you use RSS feeds, you can also use the following additional shortcodes: %%post_content%%, %%post_content_plain_text%%, %%post_excerpt%%, %%post_cats%%, %%author_name%%, %%post_link%%. The length of this command should not be greater than the max token count set in the settings for the seed command - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins). You can also add here a link to a .txt file, where you can add multiple prompts (one per line) and the plugin will select a random one at each run.", 'aiomatic-automatic-ai-content-writer') . '&nbsp;' . sprintf( wp_kses( __( "Please check some tips and tricks about writing seed commands, <a href='%s' target='_blank'>here</a>.", 'aiomatic-automatic-ai-content-writer'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://coderevolution.ro/knowledge-base/faq/how-to-create-a-good-seed-prompt-command-for-aiomatic-for-openai-gpt-3-api/' ) ) . '
                         </div>
                     </div>
                     <b>' . esc_html__("Prompt For The OpenAI Text Generator", 'aiomatic-automatic-ai-content-writer') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/how-to-create-a-good-seed-prompt-command-for-aiomatic-for-openai-gpt-3-api/" target="_blank">&#9432;</a></b>
                     
                     </td><td>
                     <textarea rows="2" cols="70" name="aiomatic_rules_list[ai_command][]" placeholder="Please insert a command for the AI" class="cr_width_full">' . esc_textarea($ai_command) . '</textarea>
                         
         </div>
         </td></tr>
         <tr><td colspan="2"><h4>' . esc_html__('Advanced AI Text Generator Options', 'aiomatic-automatic-ai-content-writer') . ':</h4></td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the maximum number of API tokens to use with each request. This will define the length of the resulting API response. Each token usually consists of approximately 4 characters. Note that in this value the number of tokens sent to the API as an article seed will also be counted. The maximum amount which can be set it 2048.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("Maximum Total Token Count To Use Per API Request", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     </td><td>
                     <input type="number" min="1" max="4000" name="aiomatic_rules_list[max_tokens][]" value="' . esc_attr($max_tokens) . '" placeholder="2048" class="cr_width_full">
                         
         </div>
         </td></tr><tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the maximum number of seed API tokens to use with each request. This will define the length of the resulting API response. Each token usually consists of approximately 4 characters. This defines how much content does the API receive each time you call it. If the API gets more initial data, better quality results will be expected. The maximum amount which can be set it 1000.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("Maximum Seed Token Count To Use Per API Request", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     </td><td>
                     <input type="number" min="1" max="1000" name="aiomatic_rules_list[max_seed_tokens][]" value="' . esc_attr($max_seed_tokens) . '" placeholder="1000" class="cr_width_full">
                         
         </div>
         </td></tr><tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the maximum number of continue API tokens to use with each request. This will define the length of the resulting API response. Each token usually consists of approximately 4 characters. This defines how much content does the API receive each time you call it. If the API gets more initial data, better quality results will be expected. The maximum amount which can be set it 500.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("Maximum Continue Token Count To Use Per API Request", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     </td><td>
                     <input type="number" min="1" max="1000" name="aiomatic_rules_list[max_continue_tokens][]" value="' . esc_attr($max_continue_tokens) . '" placeholder="500" class="cr_width_full">
                         
         </div>
         </td></tr><tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("What sampling temperature to use. Higher values means the model will take more risks. Try 0.9 for more creative applications, and 0 (argmax sampling) for ones with a well-defined answer. We generally recommend altering this or top_p but not both.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("AI Temperature", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     </td><td>
                     <input type="number" min="0" step="0.1" name="aiomatic_rules_list[temperature][]" value="' . esc_attr($temperature) . '" placeholder="1" class="cr_width_full">
                         
         </div>
         </td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered. We generally recommend altering this or temperature but not both.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("AI Top_p", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     </td><td>
                     <input type="number" min="0" step="0.1" max="1" name="aiomatic_rules_list[top_p][]" value="' . esc_attr($top_p) . '" placeholder="1" class="cr_width_full">
                         
         </div>
         </td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("AI Presence Penalty", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     </td><td>
                     <input type="number" min="-2" max="2" step="0.1" name="aiomatic_rules_list[presence_penalty][]" value="' . esc_attr($presence_penalty) . '" placeholder="0" class="cr_width_full">
                         
         </div>
         </td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("AI Frequency Penalty", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     </td><td>
                     <input type="number" min="-2" step="0.1" max="2" name="aiomatic_rules_list[frequency_penalty][]" value="' . esc_attr($frequency_penalty) . '" placeholder="0" class="cr_width_full">
                         
         </div>
         </td></tr>
         <tr><td colspan="2"><h4>' . esc_html__('AI Image Generator Options', 'aiomatic-automatic-ai-content-writer') . ':</h4></td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to enable the AI Image Generator and to replace Royalty Free Images with AI generated images?", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("Replace Royalty Free Image With AI Generated Images", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     </td><td>
                     <input type="checkbox" name="aiomatic_rules_list[enable_ai_images][]"';
             if ($enable_ai_images == '1') {
                 $output .= ' checked';
             }
             $output .= '>
         </div>
         </td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set an seed command you want to send to OpenAI image generator. This command can be any given task or order, based on which, it will generate images. You can use the following shortcodes here: %%post_title%%, %%random_sentence%%, %%random_sentence2%%, %%blog_title%%. The length of this command should not be greater than 1000 characters, otherwise the plugin will strip it to 1000 characters length. - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins). You can also add here a link to a .txt file, where you can add multiple prompts (one per line) and the plugin will select a random one at each run.", 'aiomatic-automatic-ai-content-writer') . '&nbsp;' . sprintf( wp_kses( __( "Please check some tips and tricks about writing seed commands, <a href='%s' target='_blank'>here</a>.", 'aiomatic-automatic-ai-content-writer'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://coderevolution.ro/knowledge-base/faq/how-to-create-a-good-seed-prompt-command-for-aiomatic-image-generating-for-openai-dall-e-api/' ) ) . '
                         </div>
                     </div>
                     <b>' . esc_html__("Prompt For The OpenAI Image Generator", 'aiomatic-automatic-ai-content-writer') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/how-to-create-a-good-seed-prompt-command-for-aiomatic-image-generating-for-openai-dall-e-api/" target="_blank">&#9432;</a></b>
                     
                     </td><td>
                     <textarea rows="2" cols="70" name="aiomatic_rules_list[ai_command_image][]" placeholder="Please insert a command for the AI image generator" class="cr_width_full">' . esc_textarea($ai_command_image) . '</textarea>
                         
         </div>
         </td></tr>
         <tr><td>
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the size of the generated image.", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("Generated Image Size", 'aiomatic-automatic-ai-content-writer') . ':</b>   
                     </td><td class="cr_min_width_200">
                     <select name="aiomatic_rules_list[image_size][]" class="cr_width_full">
                                   <option value="256x256"';
             if ($image_size == '256x256') {
                 $output .= ' selected';
             }
             $output .= '>' . esc_html__("256x256", 'aiomatic-automatic-ai-content-writer') . '</option>
                                   <option value="512x512"';
             if ($image_size == '512x512') {
                 $output .= ' selected';
             }
             $output .= '>' . esc_html__("512x512", 'aiomatic-automatic-ai-content-writer') . '</option>
                                   <option value="1024x1024"';
             if ($image_size == '1024x1024') {
                 $output .= ' selected';
             }
             $output .= '>' . esc_html__("1024x1024", 'aiomatic-automatic-ai-content-writer') . '</option>
                     </select>
         </div>
         </td></tr>
         <tr><td colspan="2"><h4>' . esc_html__('Manual Headings and Images List', 'aiomatic-automatic-ai-content-writer') . ':</h4></td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Add a list of headings (one on each line) to use in the generated articles. You can use the following shortcodes here: %%post_title%%, %%random_sentence%%, %%random_sentence2%%, %%blog_title%%. - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins).", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("Manual List Of Headings", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     
                     </td><td>
                     <textarea rows="2" cols="70" name="aiomatic_rules_list[headings_list][]" placeholder="Manual list of headings" class="cr_width_full">' . esc_textarea($headings_list) . '</textarea>
                         
         </div>
         </td></tr>
         <tr><td class="cr_min_width_200">
         <div>
         <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                         <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Add a list of image URLs (one on each line) to use in the generated articles. - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins).", 'aiomatic-automatic-ai-content-writer') . '
                         </div>
                     </div>
                     <b>' . esc_html__("Manual List Of Images", 'aiomatic-automatic-ai-content-writer') . ':</b>
                     
                     </td><td>
                     <textarea rows="2" cols="70" name="aiomatic_rules_list[images_list][]" placeholder="Manual list of images" class="cr_width_full">' . esc_textarea($images_list) . '</textarea>
                         
         </div>
         </td></tr>
         <tr><td colspan="2"><h4>' . esc_html__('Posting Options', 'aiomatic-automatic-ai-content-writer') . ':</h4></td></tr>
           <tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( "Select the minimum number of characters that the posts should have. If the API returns content which has fewer characters than this number, another API call will be made, until this character limit is met. Please check about API rate limiting <a href='%s'>here</a>.", 'aiomatic-automatic-ai-content-writer'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://beta.openai.com/docs/api-reference/introduction' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("AI Content Minimum Character Count", 'aiomatic-automatic-ai-content-writer') . ':</b>
                       </td><td>
                       <input type="number" min="1" step="1" name="aiomatic_rules_list[min_char][]" value="' . esc_attr($min_char) . '" placeholder="Please insert a minimum number of characters" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Enter a HTML text that should be prepended to the AI generated content in each created post. You can use the following shortcodes: %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%random_video[keyword]%%, %%royalty_free_image_attribution%% - you can also use an optional parameter in the random_image and random_video shortcodes, which will add a percentage chance for the media to appear or not - example: %%random_video[keyword][60]%% - a video will appear in 60% of cases, in the rest of 40%, nothing will be returned by the shortcode - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins).", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("HTML Text To Prepend To AI Created Content", 'aiomatic-automatic-ai-content-writer') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       </td><td>
                       <textarea rows="2" cols="70" name="aiomatic_rules_list[post_prepend][]" placeholder="HTML content to prepend to the AI generated content" class="cr_width_full">' . esc_textarea($post_prepend) . '</textarea>
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Enter a HTML text that should be append to the AI generated content in each created post. You can use the following shortcodes: %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%random_video[keyword]%%, %%royalty_free_image_attribution%% - you can also use an optional parameter in the random_image and random_video shortcodes, which will add a percentage chance for the media to appear or not - example: %%random_video[keyword][60]%% - a video will appear in 60% of cases, in the rest of 40%, nothing will be returned by the shortcode - Update: nested shortcodes also supported (shortcodes generated by rules from other plugins).", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("HTML Text To Append To AI Created Content", 'aiomatic-automatic-ai-content-writer') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       </td><td>
                       <textarea rows="2" cols="70" name="aiomatic_rules_list[post_append][]" placeholder="HTML content to append to the AI generated content" class="cr_width_full">' . esc_textarea($post_append) . '</textarea>
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the author that you want to assign for the automatically generated posts.", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Author", 'aiomatic-automatic-ai-content-writer') . ':</b>   
                       </td><td class="cr_min_width_200">
                       <select id="post_author" name="aiomatic_rules_list[post_author][]" class="cr_width_full">';
               $blogusers = get_users( [ 'role__in' => [ 'contributor', 'author', 'editor', 'administrator' ] ] );
               foreach ($blogusers as $user) {
                   $output .= '<option value="' . esc_html($user->ID) . '"';
                   if ($post_user_name == $user->ID) {
                       $output .= " selected";
                   }
                   $output .= '>' . esc_html($user->display_name) . '</option>';
               }
               $output .= '</select>  
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the status that you want for the automatically generated posts to have.", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Status", 'aiomatic-automatic-ai-content-writer') . ':</b>   
                       </td><td class="cr_min_width_200">
                       <select id="submit_status" name="aiomatic_rules_list[submit_status][]" class="cr_width_full">
                                     <option value="pending"';
               if ($status == 'pending') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Pending -> Moderate", 'aiomatic-automatic-ai-content-writer') . '</option>
                                     <option value="draft"';
               if ($status == 'draft') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Draft -> Moderate", 'aiomatic-automatic-ai-content-writer') . '</option>
                                     <option value="publish"';
               if ($status == 'publish') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Published", 'aiomatic-automatic-ai-content-writer') . '</option>
                                     <option value="private"';
               if ($status == 'private') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Private", 'aiomatic-automatic-ai-content-writer') . '</option>
                                     <option value="trash"';
               if ($status == 'trash') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Trash", 'aiomatic-automatic-ai-content-writer') . '</option>
                       </select>
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the type (post/page) for your automatically generated item.", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Item Type", 'aiomatic-automatic-ai-content-writer') . ':</b>   
                       </td><td class="cr_min_width_200">
                       <select id="default_type" name="aiomatic_rules_list[default_type][]" class="cr_width_full">';
               foreach ( get_post_types( '', 'names' ) as $post_type ) {
                  $output .= '<option value="' . esc_attr($post_type) . '"';
                  if ($def_type == $post_type) {
                       $output .= ' selected';
                   }
                  $output .= '>' . esc_html($post_type) . '</option>';
               }
                       $output .= '</select>
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to replace the imported article\'s image with a royalty free image? Please note that for this feature to function you must configure the plugin (add API keys) in the plugin\'s \'Main Settings\' menu -> \'Royalty Free Featured Image Importing Options\' section.", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Auto Get A Royalty Free Featured Image", 'aiomatic-automatic-ai-content-writer') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="royalty_free" name="aiomatic_rules_list[royalty_free][]"';
               if ($royalty_free == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Insert a comma separated list of links to valid images that will be set randomly for the featured image for the posts that do not have a valid image attached or if you disabled automatical featured image generator. You can also use image numeric IDs from images found in the Media Gallery. To disable this feature, leave this field blank. Spintax supported. You can also use the %%random_image[keyword]%% shortcode to automatically import a random image from Google Image Search with the Creative Commons filter applied. To get a related image, you can also use: %%random_image[%%post_title%%]%%", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Default Featured Image List", 'aiomatic-automatic-ai-content-writer') . ':</b>
                       </td><td>
                       <input class="cr_width_60p" type="text" name="aiomatic_rules_list[image_url][]" placeholder="Please insert the link to a valid image (spintax supported)" value="' . esc_attr($image_url) . '"/>
                       
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('If your template supports "Post Formats", than you can select one here. If not, leave this at it\'s default value.', 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Format", 'aiomatic-automatic-ai-content-writer') . ':</b>   
                       </td><td>
                       <select id="post_format" name="aiomatic_rules_list[post_format][]" class="cr_width_full">
                       <option value="post-format-standard"';
               if ($post_format == 'post-format-standard') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Standard", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="post-format-aside"';
               if ($post_format == 'post-format-aside') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Aside", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="post-format-gallery"';
               if ($post_format == 'post-format-gallery') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Gallery", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="post-format-link"';
               if ($post_format == 'post-format-link') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Link", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="post-format-image"';
               if ($post_format == 'post-format-image') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Image", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="post-format-quote"';
               if ($post_format == 'post-format-quote') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Quote", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="post-format-status"';
               if ($post_format == 'post-format-status') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Status", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="post-format-video"';
               if ($post_format == 'post-format-video') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Video", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="post-format-audio"';
               if ($post_format == 'post-format-audio') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Audio", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="post-format-chat"';
               if ($post_format == 'post-format-chat') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Chat", 'aiomatic-automatic-ai-content-writer') . '</option>
                   </select>     
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the post category that you want for the automatically generated posts to have.", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Additional Post Category", 'aiomatic-automatic-ai-content-writer') . ':</b>
                       
                       </td><td>
                       <select class="cr_width_full" id="default_category" name="aiomatic_rules_list[default_category][]">
                       <option value="aiomatic_no_category_12345678">' . esc_html__("Do Not Add a Category", 'aiomatic-automatic-ai-content-writer') . '</option>';
               $cat_args   = array(
                   "orderby" => "name",
                   "hide_empty" => 0,
                   "order" => "ASC"
               );
               $categories = get_categories($cat_args);
               foreach ($categories as $category) {
                   $output .= '<option value="' . esc_attr($category->term_id) . '"';
                   if ($category->term_id == $default_category) {
                       $output .= ' selected';
                   }
                   $output .= '>' . sanitize_text_field($category->name) . '</option>';
               }
               $output .= '</select>     
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to automatically add post categories from the feed items?", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Auto Add Categories", 'aiomatic-automatic-ai-content-writer') . ':</b>
                       
                       </td><td>
                       <select class="cr_width_full" id="auto_categories" name="aiomatic_rules_list[auto_categories][]">
                       <option value="disabled"';
               if ($auto_categories == 'disabled') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Disabled", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="title"';
               if ($auto_categories == 'title') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Title", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="content"';
               if ($auto_categories == 'content') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Content", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="both"';
               if ($auto_categories == 'both') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Title and Content", 'aiomatic-automatic-ai-content-writer') . '</option>
                       </select>                
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("This feature will try to remove the WordPress\'s default post category. This may fail in case no additional categories are added, because WordPress requires at least one post category for every post.", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Remove WP Default Post Category", 'aiomatic-automatic-ai-content-writer') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="remove_default" name="aiomatic_rules_list[remove_default][]"';
           if($remove_default == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to automatically add post tags from the feed items?", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Auto Add Tags", 'aiomatic-automatic-ai-content-writer') . ':</b>
                       
                       </td><td>
                       <select class="cr_width_full" id="auto_tags" name="aiomatic_rules_list[auto_tags][]">
                       <option value="disabled"';
               if ($auto_tags == 'disabled') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Disabled", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="title"';
               if ($auto_tags == 'title') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Title", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="content"';
               if ($auto_tags == 'content') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Content", 'aiomatic-automatic-ai-content-writer') . '</option>
                       <option value="both"';
               if ($auto_tags == 'both') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Title and Content", 'aiomatic-automatic-ai-content-writer') . '</option>
                       </select>     
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the post tags that you want for the automatically generated posts to have. Spintax supported.", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Additional Post Tags", 'aiomatic-automatic-ai-content-writer') . ':</b>
                       
                       </td><td>
                       <input class="cr_width_full" type="text" name="aiomatic_rules_list[default_tags][]" value="' . esc_attr($default_tags) . '" placeholder="Please insert your additional post tags here" >
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to enable comments for the generated posts?", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Enable Comments For Posts", 'aiomatic-automatic-ai-content-writer') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="enable_comments" name="aiomatic_rules_list[enable_comments][]"';
               if ($enable_comments == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to enable pingbacks and trackbacks for the generated posts?", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Enable Pingback/Trackback", 'aiomatic-automatic-ai-content-writer') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="enable_pingback" name="aiomatic_rules_list[enable_pingback][]"';
               if ($enable_pingback == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the custom fields that will be set for generated posts. The syntax for this field is the following: custom_field_name1 => custom_field_value1, custom_field_name2 => custom_field_value2, ... .", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Custom Fields", 'aiomatic-automatic-ai-content-writer') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       
                       </td><td>
                       <textarea rows="1" cols="70" name="aiomatic_rules_list[custom_fields][]" placeholder="Please insert your desired custom fields. Example: title_custom_field => %%post_title%%" class="cr_width_full">' . esc_textarea($custom_fields) . '</textarea>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the custom taxonomies that will be set for generated posts. The syntax for this field is the following: custom_taxonomy_name1 => custom_taxonomy_value1A, custom_taxonomy_value1B; custom_taxonomy_name2 => custom_taxonomy_value2A, custom_taxonomy_value2B; ... .", 'aiomatic-automatic-ai-content-writer') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Custom Taxonomies", 'aiomatic-automatic-ai-content-writer') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       </td><td>
                         <textarea rows="1" cols="70" name="aiomatic_rules_list[custom_tax][]" placeholder="Please insert your desired custom taxonomies. Example: custom_taxonomy_name => %%post_title%%" class="cr_width_full">' . esc_textarea($custom_tax) . '</textarea>  
           </div>
           </td></tr><tr><td>
           <div>
          <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                          <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Enter a 2 letter language code that will be assigned as the WPML/Polylang language for posts. Example: for German, input: de", 'aiomatic-automatic-ai-content-writer') . '
                          </div>
                      </div>
                      <b>' . esc_html__("Assign WPML/Polylang Language to Posts", 'aiomatic-automatic-ai-content-writer') . ':</b>
                      
                      </td><td>
                      <input type="text" class="cr_width_full" name="aiomatic_rules_list[wpml_lang][]" value="' . esc_attr($wpml_lang) . '" placeholder="WPML/Polylang language" class="cr_width_full">
                          
          </div>
          </td></tr></table></div> 
       </div>
       <div class="codemodalfzr-footer">
         <br/>
         <h3 class="cr_inline">Aiomatic Automatic Post Generator</h3><span id="aiomatic_ok' . esc_html($cont) . '" class="codeokfzr cr_inline">OK&nbsp;</span>
         <br/><br/>
       </div>
     </div>
   
   </div>       
                       </td>
   						<td class="cr_shrt_td2"><span class="wpaiomatic-delete">X</span></td>
                           <td class="cr_short_td"><input type="checkbox" name="aiomatic_rules_list[active][]" class="activateDeactivateClass" value="1"';
               if (isset($active) && $active === '1') {
                   $output .= ' checked';
               }
               $output .= '/>
                           <input type="hidden" name="aiomatic_rules_list[last_run][]" value="' . esc_attr($last_run) . '"/></td>
                           <td class="cr_shrt_td2"><div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Shortcode for this rule<br/>(to cross-post from this plugin in other plugins):', 'aiomatic-automatic-ai-content-writer'), array(  'br' => array( ) ) ) ) . '<br/><b>%%aiomatic_0_' . esc_html($cont) . '%% and %%aiomatic_title_0_' . esc_html($cont) . '%%</b><br/>' . esc_html__('Posts Generated:', 'aiomatic-automatic-ai-content-writer') . ' ' . esc_html($generated_posts) . '<br/>';
               if ($generated_posts != 0) {
                   $output .= '<a href="' . get_admin_url() . 'edit.php?coderevolution_post_source=Aiomatic_' . esc_html($cont) . '&post_type=' . esc_html($def_type) . '" target="_blank">' . esc_html__('View Generated Posts', 'aiomatic-automatic-ai-content-writer') . '</a><br/>';
               }
               $output .= esc_html__('Last Run: ', 'aiomatic-automatic-ai-content-writer');
               if ($last_run == '1988-01-27 00:00:00') {
                   $output .= 'Never';
               } else {
                   $output .= $last_run;
               }
               $output .= '<br/>' . esc_html__('Next Run: ', 'aiomatic-automatic-ai-content-writer');
               $nextrun = aiomatic_add_hour($last_run, $schedule);
               $now     = aiomatic_get_date_now();
               if (isset($active) && $active === '1') {
                   $aiomatic_hour_diff = (int) aiomatic_hour_diff($now, $nextrun);
                   if ($aiomatic_hour_diff >= 0) {
                       $append = 'Now.';
                       $cron   = _get_cron_array();
                       if ($cron != FALSE) {
                           $date_format = _x('Y-m-d H:i:s', 'Date Time Format1', 'aiomatic-automatic-ai-content-writer');
                           foreach ($cron as $timestamp => $cronhooks) {
                               foreach ((array) $cronhooks as $hook => $events) {
                                   if ($hook == 'aiomaticaction') {
                                       foreach ((array) $events as $key => $event) {
                                           $append = date_i18n($date_format, $timestamp);
                                       }
                                   }
                               }
                           }
                       }
                       $output .= $append;
                   } else {
                       $output .= $nextrun;
                   }
               } else {
                   $output .= esc_html__('Rule Disabled', 'aiomatic-automatic-ai-content-writer');
               }
               $output .= '<br/>' . esc_html__('Local Time: ', 'aiomatic-automatic-ai-content-writer') . $now;
               $output .= '</div>
                       </div></td>
                           <td class="cr_center">
                           <div>
                           <img id="run_img' . esc_html($cont) . '" src="' . plugin_dir_url(dirname(__FILE__)) . 'images/running.gif' . '" alt="Running" class="cr_status_icon';
               if (!empty($running)) {
                   if (!in_array($cont, $running)) {
                       $output .= ' cr_hidden';
                   }
                   else
                   {
                       $f = fopen(get_temp_dir() . 'aiomatic_' . $cont, 'w');
                       if($f !== false)
                       {
                           if (!flock($f, LOCK_EX | LOCK_NB)) {
                           }
                           else
                           {
                               $output .= ' cr_hidden';
                               flock($f, LOCK_UN);
                               if (($xxkey = array_search($cont, $running)) !== false) {
                                   unset($running[$xxkey]);
                                   update_option('aiomatic_running_list', $running);
                               }
                           }
                       }
                   }
               } else {
                   $output .= ' cr_hidden';
               }
               $output .= '" title="status">
                           <div class="codemainfzr">
                           <select id="actions" class="actions" name="actions" onchange="actionsChangedManual(' . esc_html($cont) . ', this.value);" onfocus="this.selectedIndex = 0;">
                               <option value="select" disabled selected>' . esc_html__("Select an Action", 'aiomatic-automatic-ai-content-writer') . '</option>
                               <option value="run">' . esc_html__("Run This Rule Now", 'aiomatic-automatic-ai-content-writer') . '</option>
                               <option value="trash">' . esc_html__("Move All Posts To Trash", 'aiomatic-automatic-ai-content-writer') . '</option>
                               <option value="duplicate">' . esc_html__("Duplicate This Rule", 'aiomatic-automatic-ai-content-writer') . '</option>
                               <option value="delete">' . esc_html__("Permanently Delete All Posts", 'aiomatic-automatic-ai-content-writer') . '</option>
                           </select>
                           </div>
                           </div>
                           </td>
   					</tr>	
   					';
               $cont = $cont + 1;
           }
       }
       return $output;
   }
   ?>