"use strict";
function aiomatic_playground_submit()
{
    if (confirm("Are you sure you want to submit this to OpenAI?") == true) {
        var txtarea = document.getElementById("aiomatic_playground_input").value;
        var aiomatic_playground_nonce = document.getElementById("_aiomatic_nonce").value;
        var max_seed_tokens = document.getElementById("max_seed_tokens").value;
        var max_tokens = document.getElementById("max_tokens").value;
        var temperature = document.getElementById("temperature").value;
        var frequency_penalty = document.getElementById("frequency_penalty").value;
        var top_p = document.getElementById("top_p").value;
        var presence_penalty = document.getElementById("presence_penalty").value;
        var model = document.getElementById("model").value;
        txtarea = txtarea.trim();
        if(txtarea == '')
        {
            document.getElementById('playgroundSubmit').removeAttribute('disabled');
            document.getElementById("aiomatic_playground_status").innerHTML = 'Empty input detected, please add a valid input! ';
            return;
        }
        document.getElementById('playgroundSubmit').setAttribute('disabled','disabled');
        document.getElementById("aiomatic_playground_status").innerHTML = 'Working... (please do not close or refresh this page) ';
        var data = {
             action: 'aiomatic_ajax_playground',
             seed: txtarea,
             aiomatic_nonce: aiomatic_playground_nonce,
             max_seed_tokens: max_seed_tokens,
             max_tokens: max_tokens,
             temperature: temperature,
             top_p: top_p,
             presence_penalty: presence_penalty,
             frequency_penalty: frequency_penalty,
             model: model
        };
        jQuery.post(ajaxurl, data, function(response) {
            if(response.startsWith("Error:"))
            {
                document.getElementById('playgroundSubmit').removeAttribute('disabled');
                document.getElementById("aiomatic_playground_status").innerHTML = response;
            }
            else
            {
                document.getElementById('playgroundSubmit').removeAttribute('disabled');
                document.getElementById("aiomatic_playground_status").innerHTML = 'Done! ';
                document.getElementById("aiomatic_rich_form").value = response;
            }
        }).fail( function(xhr) 
        {
            document.getElementById("aiomatic_playground_status").innerHTML = 'An error occurred, please try again later!';
            console.log('Error occured in processing: ' + xhr.statusText);
            document.getElementById('playgroundSubmit').removeAttribute('disabled');
        });
    } else {
        return;
    }
}