<?php 
namespace GenieAi\App\ProLabel;

use GenieAi\App\ProLabel\GenieRating;

class ProLabelInit{
    public function __construct()
    {
        add_action('wp_loaded', function(){
            $this->includeFiles();
            $this->filterString = self::active_plugins();
            \GenieAi\App\ProLabel\GenieNotice::init();
    
            $this->initBanner();
            // $this->initStories();
            $this->initRating();
        });
    }

    private function includeFiles(){
        include 'GenieNotice.php';
        include 'Banner.php';
        // include 'Stories.php';
        // include 'Rating.php';
    }

    public static function active_plugins() {
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
		$apl           = get_option( 'active_plugins' );
		$plugins       = get_plugins();
		$filter_string = '';
		foreach ( $apl as $p ) {
			if ( isset( $plugins[ $p ] ) && isset( $plugins[ $p ]['TextDomain'] ) ) {
				$filter_string .= ',' . $plugins[ $p ]['TextDomain'];
			}
		}
		return ltrim( $filter_string, ',' );
	}

    private function initBanner(){
        /**
         * Show WPMET banner (codename: jhanda)
         */
        \Wpmet\Libs\Banner::instance( 'getgenie' )
        // ->is_test(true)
        ->set_filter( $this->filterString )
        ->set_api_url( 'https://api.wpmet.com/public/jhanda' )
        ->set_plugin_screens( 'toplevel_page_getgenie' )
        ->call();
    }

    private function initRating(){
        /**
         * Show GenieAi rating (codename: rating)
         */
        GenieRating::instance( 'getgenie' )
        ->set_plugin('GetGenie', 'https://wordpress.org/support/plugin/getgenie/reviews/')
        ->set_plugin_logo('https://ps.w.org/getgenie/assets/icon-256x256.gif?rev=2798355', 'width:150px !important')
        ->set_allowed_screens('toplevel_page_getgenie')
        ->set_priority( 10 )
        ->set_first_appear_day( 7 )
        ->set_condition( true )
        ->call();
    }
}
